// CDocDict.cp
// CDocDict.h
// ----------------------------------------------------------------------------------
// A Document dictionary class.
//
// This is a bloom based dictionary that acts a cache during spell checking.  When
// a user decides to 'ignore' a word it is placed in this dictonary.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/13/94
//			Made the buffer into an abstract C++ class that was basically
//			an abstract datafile class.
// ----------------------------------------------------------------------------------

// ----------------------------------------------------------------------------------
// Includes

#include <string.h>
#include "UBloom.h"
#include "CDict.h"
#include "Tspell.h"

//#define

class CDocDict : public CDict 
{
public:
	CDocDict(long NumBuffers, FioParam * theFile);
	~CDocDict();

	short Add(char *Word);
	short Check(char *Word);
	
private:
	UBloom	*DocFilter;
	long		NumWords;
	long		MaxWords;
	short		Usable;			// flag to see if the dictionary is actually
							// useable, so that we can avoid exception
							// handling which is slow and not standard on
							// all C++ compiliers.
	
}; // CDocDict


